﻿using AZVIC.Ei8htPOS.POSRetail.Constants;
using AZVIC.Ei8htPOS.POSRetail.Helpers;
using AZVIC.Ei8htPOS.POSRetail.Pages;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Windows.Threading;

namespace AZVIC.Ei8htPOS.POSRetail
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MasterWindow : Window
    {
        public MasterWindow()
        {
            InitializeComponent();
            StartTimer();
        }

        private void StartTimer()
        {
            System.Windows.Threading.DispatcherTimer dispatcherTimer = new System.Windows.Threading.DispatcherTimer();
            dispatcherTimer.Tick += new EventHandler(dispatcherTimer_Tick);
            dispatcherTimer.Interval = new TimeSpan(0, 0, 1);
            dispatcherTimer.Start();
        }
        private void dispatcherTimer_Tick(object sender, EventArgs e)
        {
            lblTimer.Text = DateTime.Now.ToString("dd MMM hh:mm ss tt");
        }

        #region Event Handlers
        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            LoadPages(new Login(), string.Empty);
        }

        private void btnClose_Click(object sender, RoutedEventArgs e)
        {
            //TODO: UnComment on Final Delivery
            //Open Dialog to verify Closure.
            if (App.ConfirmationDialog(UIConstants.EXIT_CONFIRMATION, UIConstants.EXIT_CONFRIM_HEADER))
            {
                PoleDisplayHelper.ClearDisplay();
                Application.Current.Shutdown();
            }
        }

        private void btnMinimize_Click(object sender, RoutedEventArgs e)
        {
            //Minimize Window.
            this.WindowStyle = WindowStyle.SingleBorderWindow;
            this.WindowState = WindowState.Minimized;
        }
        protected override void OnStateChanged(EventArgs e)
        {
            if (WindowState == WindowState.Maximized)
            {
                this.WindowStyle = WindowStyle.None;
            }
        }
        #endregion

        public void ShowHideCopyrightInfo(bool ShowInfo)
        {
            lblUserName.Visibility = ShowInfo ? Visibility.Visible : Visibility.Hidden;
            lblWelcome.Visibility = ShowInfo ? Visibility.Visible : Visibility.Collapsed;
            lblCopyright.Visibility = ShowInfo ? Visibility.Visible : Visibility.Collapsed;
        }

        private Frame ReturnNavFrame(string FrameName)
        {
            Window myWindow = Application.Current.MainWindow as Window;
            Frame myFrame = null;
            if (myWindow != null)
            {
                myFrame = myWindow.FindName(FrameName) as Frame;

            }
            return myFrame;
        }

        #region Frame Navigation - Transition
        private bool _allowDirectNavigation = false;
        private NavigatingCancelEventArgs _navArgs = null;
        private Duration _duration = new Duration(TimeSpan.FromMilliseconds(200));
        private double _oldHeight = 0;

        private void frame_Navigating(object sender, NavigatingCancelEventArgs e)
        {

            if (Content != null && !_allowDirectNavigation)
            {
                e.Cancel = true;

                _navArgs = e;
                _oldHeight = FrmAppWindow.ActualHeight;

                DoubleAnimation animation0 = new DoubleAnimation();
                animation0.From = 1;
                animation0.To = 0;
                animation0.Duration = _duration;
                animation0.Completed += SlideCompleted;
                FrmAppWindow.BeginAnimation(OpacityProperty, animation0);
            }
            _allowDirectNavigation = false;

        }

        private void SlideCompleted(object sender, EventArgs e)
        {

            _allowDirectNavigation = true;
            switch (_navArgs.NavigationMode)
            {
                case NavigationMode.New:
                    if (_navArgs.Uri == null)
                        FrmAppWindow.Navigate(_navArgs.Content);
                    else
                        FrmAppWindow.Navigate(_navArgs.Uri);
                    break;
                case NavigationMode.Back:
                    FrmAppWindow.GoBack();
                    break;
                case NavigationMode.Forward:
                    FrmAppWindow.GoForward();
                    break;
                case NavigationMode.Refresh:
                    FrmAppWindow.Refresh();
                    break;
            }

            Dispatcher.BeginInvoke(DispatcherPriority.Loaded,
                (ThreadStart)delegate()
                {

                    DoubleAnimation animation0 = new DoubleAnimation();
                    animation0.From = 0;
                    animation0.To = 1;
                    animation0.Duration = _duration;
                    FrmAppWindow.BeginAnimation(OpacityProperty, animation0);
                });
        }

        private void frmContent_Navigated(object sender, NavigationEventArgs e)
        {

        }

        #endregion

        #region Navigation Service

        public void LoadPages(Page PageName, string ActiveMenu)
        {
            Frame NavFrame = ReturnNavFrame(Constants.Controls.CONTENT_FRAME);
            NavFrame.Navigate(PageName);
            LoadMenu(ActiveMenu);
        }

        /// <summary>
        /// Used to Load the Menu and highlight the current page.
        /// </summary>
        /// <param name="ActiveMenu">Send the Name of Active Page. For Login Page, Send Empty String </param>
        public void LoadMenu(string ActiveMenu)
        {
            Frame NavMenu = ReturnNavFrame(Constants.Controls.MENU_FRAME);
            if (string.IsNullOrEmpty(ActiveMenu))
            {
                NavMenu.Navigate(null);
            }
            else { NavMenu.Navigate(new Menu(ActiveMenu)); };

        }

        #endregion

        

        public void UpdateCustomerName()
        {
            lblUserName.Text = AppSession.CurrentUser != null ? AppSession.CurrentUser.FirstName + " " + AppSession.CurrentUser.LastName : "- Ei8ht POS";
        }
    }
}
